#include <windows.h>
#include <stdio.h>
#include "../s1w.h"
#include "../s1w_i.c"

int main(void)
{
    IS1Diag *pS1Diag;
    char buff[4096];
    wchar_t* wbuff;
    BSTR res;
    HRESULT hres;
    int len;

    CoInitialize(NULL);
    if( SUCCEEDED(CoCreateInstance(CLSID_S1Diag,0,CLSCTX_LOCAL_SERVER,IID_IS1Diag,(void**)&pS1Diag)) ){
        gets(buff); // read response from stdin
        len=strlen(buff)+1;
        wbuff=SysAllocStringLen(0,len);
        if( wbuff ){
            MultiByteToWideChar(CP_ACP,0,buff,-1,wbuff,len);
            hres=pS1Diag->get_S1Diag(wbuff,&res);
            if( SUCCEEDED(hres) ){
                WideCharToMultiByte(CP_ACP,0,res,-1,buff,sizeof(buff),0,0);
                SysFreeString(res);
                puts(buff);
            }else printf( "cannot get diagnostics: 0x%08x\n", hres );
            SysFreeString(wbuff);
        }
        pS1Diag->Release();
    }
    CoUninitialize();
    return 0;
}

