#include <tchar.h>
#include <stdio.h>
#include <io.h>

#define _Istdigit(c) ((c)>=_T('0') && (c)<=_T('9'))
#define _Istalnum(c) (((c)>=_T('a') && (c)<=_T('z')) || ((c)>=_T('A') && (c)<=_T('Z')) || ((c)>=_T('0') && (c)<=_T('9')))

static const TCHAR szLogo1[]=_T("windows log Rockwell statistics recovery, v 1.0");
static const TCHAR szLogo2[]=_T("copyright (c) 2002, Stanislav V. Mekhanoshin");
static const TCHAR szLogo3[]=_T("http://www.rampitec.spb.ru");
static const TCHAR szLogo4[]=_T("\nusage: s1xplog <windows-modem-log.txt >s1-log.txt");
static const TCHAR szDash[]=_T(" - ");
static const TCHAR szColon[]=_T(": ");
static const TCHAR szBegin[]=_T("BEGIN");
static const TCHAR szEnd[]=_T("END");
static const TCHAR szNoStat[]=_T("no statistics found");

int __cdecl _tmain(void)
{
    TCHAR in[512];
    TCHAR out[4096];
    TCHAR *p;
    int status=0;
    int iout=0;

    if( isatty(fileno(stdin)) ){
        _putts( szLogo1 );
        _putts( szLogo2 );
        _putts( szLogo3 );
        _putts( szLogo4 );
        return 1;
    }

    out[0]=0;
    while( _fgetts(in,sizeof(in)/sizeof(in[0]), stdin) ){
        if( !_Istdigit( in[0] ) || _tcslen(in)<13 ) continue;
        if( (p = _tcsstr( &in[11], szDash ))==0 ) continue;
        if( (p = _tcsstr( p, szColon ))==0 ) continue;
        p += 2;
        if( status==0 && (p = _tcsstr( p, szBegin ))!=0 ) status=1;
        if( status==0 ) continue;
        while( *p && _Istalnum(*p) ) out[iout++] = *p++;
        out[iout] = 0;
        p = _tcsstr( out, szEnd );
        if( p ){
            iout = p + 3 - out;
            out[iout] = 0;
            status = 2;
            break;
        }
    }

    switch( status ){
    case 0:
         _putts( szNoStat );
         break;
    case 1: /* only partial statistics found */
    case 2: /* full partial statistics found */
         _putts( out );
    }

    return 0;
}

