#ifndef _FIDOMSG_H_
#define _FIDOMSG_H_

#include <string.h>
#include <stdio.h>

/*
** Stored message header.
** This is format used for stored messages, to speed up processing,
** all fields except text have fixed length.
*/

#pragma ZTC align 1
#pragma pack(push,1);

typedef struct _MSG_HDR{
    char                fromuser[36];    /* fromuser name */
    char                touser[36];      /* touser name */
    char                subject[72];     /* subject */
    char                datetime[20];    /* date & time */
    unsigned short int  timesread,       /* read counter */
                        destnode,        /* destination node */
                        orignode,        /* origin node */
                        cost,            /* cost */
                        orignet,         /* origin net */
                        destnet,         /* destination net */
                        destzone,        /* reserved space... */
                        origzone,
                        destpoint,
                        origpoint,
                        replyto,         /* message number it's reply to */
                        attribute,       /* attribute */
                        nxtreply;        /* next reply number */
}MSG_HDR;

typedef struct _tAddress{
    unsigned short int Zone;
    unsigned short int Net;
    unsigned short int Node;
    unsigned short int Point;
#ifdef __cplusplus
    operator char* () const
    {
        static char buff[32];
        sprintf( buff, "%d:%d/%d", Zone, Net, Node );
        if( Point )sprintf( &buff[strlen(buff)], ".%d", Point );
        return buff;
    }
#endif
}tAddress;

#ifdef __cplusplus

inline int operator==( const tAddress a, const tAddress b )
    { return !memcmp(&a,&b,sizeof(tAddress)); };

inline int operator!=( const tAddress a, const tAddress b )
    { return memcmp(&a,&b,sizeof(tAddress)); };

inline int operator>( const tAddress a, const tAddress b )
    {
        if(a.Zone>b.Zone)return 1;
        else if(a.Zone<b.Zone)return 0;
        else if(a.Net>b.Net)return 1;
        else if(a.Net<b.Net)return 0;
        else if(a.Node>b.Node)return 1;
        else if(a.Node<b.Node)return 0;
        else if(a.Point>b.Point)return 1;
        return 0;
    }

inline int operator<( const tAddress a, const tAddress b )
    {
        if( a==b )return 0;
        if( a>b ) return 0;
        return 1;
    };

#endif


#pragma ZTC align
#pragma pack(pop);

/*
** Message Attribute bits.
*/
#define MA_Private          0x0001   /* not zeroed before packeting */
#define MA_Crash            0x0002   /* SEAdog, not zeroed before packeting */
#define MA_Recd             0x0004
#define MA_Sent             0x0008
#define MA_FileAttached     0x0010   /* not zeroed before packeting */
#define MA_InTransit        0x0020
#define MA_Orphan           0x0040
#define MA_KillSent         0x0080
#define MA_Local            0x0100
#define MA_HoldForPickup    0x0200    /* SEAdog only */
#define MA_unused           0x0400    /* not zeroed before packeting */
#define MA_FileReq          0x0800    /* SEAdog only */
#define MA_RetRecptReq      0x1000    /* SEAdog, not zeroed before packeting */
#define MA_IsRetReceipt     0x2000    /* SEAdog, not zeroed before packeting */
#define MA_AuditReq         0x4000    /* SEAdog, not zeroed before packeting */
#define MA_FileUpdReq       0x8000    /* SEAdog only */

#endif
