/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#ifndef _LISTDEF_HPP_
#define _LISTDEF_HPP_

#include <stddef.h>
#include <malloc.h>
#include <string.h>

template <class Type>
class listtemp{
    public:

    listtemp( void ) { list=NULL; cnt=0; };
    ~listtemp( void ) { free(list); };
    Type *list;
    unsigned int cnt;
    bool add( const Type &val ){
        list=(Type*)realloc( list, ++cnt*sizeof(Type) );
        if(!list)return false;
        memcpy( &list[cnt-1], &val, sizeof(Type) );
        return true;
    };
    bool remove( unsigned int index ){
        if( !cnt || index>=cnt )return false;
        if( index!=--cnt)memmove( &list[index], &list[index+1], (cnt-index)*sizeof(Type) );
        list=(Type*)realloc( list, cnt*sizeof(Type) );
        if( cnt && !list )return false;
        return true;
    };
    Type& get( unsigned int index ){
        return list[index];
    };
    bool inlist( const Type& val ){
        for( int i=0; i<cnt; i++ )
            if( !memcmp( &list[i], &val, sizeof(Type)) )return true;
        return false;
    };
};

#endif
