/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <malloc.h>
#include <conio.h>
#include "sf-graph.h"
#include "fidomsg.h"

MsgClsList MsgCls[loCounter];
SessionList SList;

static BUSY busy[24];               // Static memo zeroed!

static long     lastSpeed;
static char     lastMailer[32];
static char     lastMailerV1[32];
static char     lastMailerV2[32];
static tAddress lastAddress;
// static bool     isHydra;
static long     lastFileTime;
static long     lastOnline;

void offline(void)
{
    int i;

    for( i=0; i<24; i++ )busy[i].off = 3600;
}

static bool atoaddr( tAddress &addr, char *s )
{
    char *p=s;
    addr.Point=0;

    while( *p && isdigit(*p) )p++;
    if( p==s )return false;
    addr.Zone=(unsigned short)atoi(s);
    s=p++;
    if( *s++!=':' )return false;

    while( *p && isdigit(*p) )p++;
    if( p==s )return false;
    addr.Net=(unsigned short)atoi(s);
    s=p++;
    if( *s++!='/' )return false;

    while( *p && isdigit(*p) )p++;
    if( p==s )return false;
    addr.Node=(unsigned short)atoi(s);
    s=p;
    if( *s!='.' )goto F;

    p++;s++;
    while( *p && isdigit(*p) )p++;
    if( p==s )goto F;
    addr.Point=(unsigned short)atoi(s);

F:  return *p==NULL || isspace(*p) || *p==',';
}

static int cmpSesAddress( const void *p1, const void *p2 )
{
    if( ((SessionInfo*)p1)->address == ((SessionInfo*)p2)->address )return 0;
    if( ((SessionInfo*)p1)->address > ((SessionInfo*)p2)->address )return 1;
    return -1;
}

static int cmpSesOnline( const void *p1, const void *p2 )
{
    long res=((SessionInfo*)p1)->online-((SessionInfo*)p2)->online;
    if( res<0l )return -1;
    if( res>0l )return 1;
    return cmpSesAddress(p1,p2);
}

static int cmpSesSessions( const void *p1, const void *p2 )
{
    int res=int(((SessionInfo*)p1)->ses-((SessionInfo*)p2)->ses);
    if( res )return res;
    return cmpSesAddress(p1,p2);
}

static int cmpSesCPS( const void *p1, const void *p2 )
{
    long CPS1=((SessionInfo*)p1)->filetime?(((SessionInfo*)p1)->in+((SessionInfo*)p1)->out)/((SessionInfo*)p1)->filetime:0l;
    long CPS2=((SessionInfo*)p2)->filetime?(((SessionInfo*)p2)->in+((SessionInfo*)p2)->out)/((SessionInfo*)p2)->filetime:0l;
    int res=int(CPS1-CPS2);
    if( res )return res;
    return cmpSesAddress(p1,p2);
}

static int cmpSesTraffic( const void *p1, const void *p2 )
{
    long res=((SessionInfo*)p1)->in+((SessionInfo*)p1)->out-
             ((SessionInfo*)p2)->in-((SessionInfo*)p2)->out;
    if( res>0l )return 1;
    if( res<0l )return -1;
    return cmpSesAddress(p1,p2);
}

static int cmpSesEff( const void *p1, const void *p2 )
{
    int res=int(((SessionInfo*)p1)->eff-((SessionInfo*)p2)->eff);
    if( res )return res;
    return cmpSesAddress(p1,p2);
}

static int (*cmpf)( const void* p1, const void* p2 );
bool showg=true, showw=true, showt=true, showm=true;

int main( int ac, char *av[] )
{
    FILE *handle;
    char str[256];
    struct tm *tp;
    time_t newtime;
    int call;
    int min;
    int dl1 = 11;
    int dl2 = 11;
    int middle = 0;
    int xit = 0;
    int handleBin;
    static char last[]="00:00:00";
    char *date1 = (char*)alloca(12);
    char *date2 = (char*)alloca(12);
    struct stat stout;
    int lastperc=-1;
    char sortby='a';
    char *sortname;

    if(!isatty(fileno(stdout)))if(!fstat(fileno(stdout),&stout))if(stout.st_size>0)puts("");
    printf( "SF-Graph/"HOST_OS" v"VERSION", (c) SF-Team, (p) Stas Mehanoshin (2:5030/172.9), 1995-2000\n\n" );
    if( ac < 3 ){
        puts( "usage: sf-graph logfile lng-file [{dd.mm.yy}|/y [/<show-list>]]" );
        puts( "       /y - use yesterday's date" );
        puts( "         <show-list> ::== <item>[<item>[<item>...]]" );
        puts( "           <item> ::== {g|w|t[{a|t|c|o|s|e}]|m}\n" );
        puts( "           g - show work-load Graph" );
        puts( "           w - show overall Work-load" );
        puts( "           t - show Traffic statistics" );
        puts( "               a - sort by Address" );
        puts( "               t - sort by Traffic" );
        puts( "               c - sort by Cps" );
        puts( "               o - sort by Online-time" );
        puts( "               s - sort by number of Sessions" );
        puts( "               e - sort by efficiency" );
        puts( "           m - show Mailer usage" );
        puts( "         <show-list> default is gwtam" );
        puts( "\nexample: sf-graph sf-mail.log sf-mail.lng /y /gwtcm" );
        puts( "       shows all statistics for yesterday with" );
        puts( "       traffic statistics sorted by CPS" );
        return 1;
    }
    getlang(av[2]);
    handle = fdopen( (handleBin = sopen( av[1], O_RDONLY, SH_DENYNO )), "r" );
    if( !handle ){
        perror( "cannot open log-file" );
        return 2;
    }
    if( ac > 3 ){
        struct tm t;
        if( av[3][0]=='/' && av[3][1]=='y' ){
            time(&newtime);
            tp = localtime(&newtime);
            tp->tm_hour = 0;
            tp->tm_min = 0;
            tp->tm_sec = 0;
            tp->tm_isdst = -1;
            newtime = mktime(tp);
        }else{
            t.tm_sec = t.tm_min = t.tm_hour = t.tm_wday = t.tm_yday = 0;
            t.tm_isdst = -1;
            sscanf( av[3], "%d.%d.%d", &t.tm_mday, &t.tm_mon, &t.tm_year );
            if( t.tm_year>99 )t.tm_year-=1900; // 3 or more digits
            else if( t.tm_year<=50 )t.tm_year+=100; // beginning of century
            t.tm_mon--;
            newtime = mktime( &t )+24l*60l*60l;
        }
        middle = 1;
    }else time(&newtime);
    if( ac>4 && av[4][0]=='/' ){
        char *p;
        strlwr( av[4] );
        showg=(strchr(av[4],'g')!=NULL);
        showw=(strchr(av[4],'w')!=NULL);
        p=strchr(av[4],'t');
        if( p ){
            if(p[1])if( strchr( "atcose", p[1] ) )sortby=p[1];
        }else showt=false;
        showm=(strchr(av[4],'m')!=NULL);
    }
    newtime -= newtime%(60l*60l);
    tp = localtime(&newtime);
    strftime(date1, dl1+1, "%d %b %Y", tp);
    newtime -= 24l*60l*60l;         // Day early
    tp = localtime(&newtime);
    strftime(date2, dl2+1, "%d %b %Y", tp);
    if( date1[0] == '0' ){
        date1++;
        dl1--;
    }
    if( date2[0] == '0' ){
        date2++;
        dl2--;
    }
    while( !feof( handle) ){
        if( isatty(fileno(stdout)) ){
            int perc;
            perc=(int)(ftell(handle)*100/filelength(fileno(handle)));
            if(perc>lastperc){
                cprintf("\rProcessing log file %02d%% done...", perc);
                lastperc=perc;
            }
        }
        if( !fgets( str, 256, handle ) ){
//            perror( "cannot read configuration file" );
//            return 100;
            offline();
            goto Skip;
        }
        if( !strncmp( str, "", 10 ) ){
            if( !strncmp( &str[12], date2, dl2 ) )break;      // May be not present!
            if( !strncmp( &str[12], date1, dl1 ) ){
                if( middle ){
                    offline();
                    goto Skip;
                }
                else break;
            }
        }
    }
    if( feof( handle ) ){
        offline();
        goto Skip;
    }
    min = -1;
    while( !feof( handle) ){
        fgets( str, 256, handle );
        if( isdigit(str[0]) ){
            if( atoi( str ) >= tp->tm_hour )break;
            if( atoi( str ) < min )break;
            if( min==-1 )min = atoi( str );
        }
    }
    if( feof( handle ) ){
        offline();
        goto Skip;
    }
    for( call = tp->tm_hour; 1; call++ ){
        if( call == 24 )call = 0;
        if( call == atoi( str ) )break;
        busy[ call ].off = 3600;
    }
    busy[ call ].off = (atoi( &str[3] )*60+atoi( &str[6] ));
    while( !feof( handle) ){
        int hour;

        fgets( str, 256, handle );
LOOP:   if( feof( handle ) ){
            break;
//            xit = 1;
        }
        if( isatty(fileno(stdout)) ){
            int perc;
            perc=(int)(ftell(handle)*100/filelength(fileno(handle)));
            if(perc>lastperc){
                cprintf("\rProcessing log file %02d%% done...", perc);
                lastperc=perc;
            }
        }
        if( middle ){
            if( !strncmp( str, "", 10 ) ){
                if( !strncmp( &str[12], date1, dl1 ) ){
                    if( !xit )goto Skip;
                    else{
                        xit = 2;
                        strcpy( str, "00:00:00" );
                    }
                }
            }
        }
        call = 0;
        if( isdigit(str[0]) ){
FillXit:    if( xit ){
                if( atoi( str ) == atoi(last) ){
                    busy[atoi(str)].off += (atoi( &str[3] )-atoi( &last[3] ))*60+atoi( &str[6] )-atoi( &last[6] );
                }else{
                    busy[ atoi(last) ].off += 3600 - (atoi( &last[3] )*60+atoi( &last[6] ));
                    for( hour = atoi(last)+1; 1; hour++ ){
                        if( hour == 24 )hour = 0;
                        if( hour == atoi(str) )break;
                        busy[hour].off = 3600;
                    }
                    busy[ hour ].off += atoi( &str[3] )*60+atoi( &str[6] );
                }
                if( xit == 2 )goto Skip;
                xit = 0;
            }
            if(lastSpeed && isLog(str,loTraffic)){
                char in[24],out[24];
                match( MsgCls[loTraffic].msg[0], &str[10], '1', out );
                match( MsgCls[loTraffic].msg[0], &str[10], '2', in );
                if( !SList.add( lastAddress, atol(in), atol(out), lastFileTime, lastOnline, lastSpeed,
                                lastMailer, lastMailerV1, lastMailerV2 ) ){
                    perror( "cannot store info" );
                    exit(1);
                }
/*
                {
                    tAddress a={2,5030,172,56};
                    if( lastAddress==a ){
                        printf( "%s in: %s out: %s, FileTime: %ld speed: %ld, eff: %d\n", (char*)lastAddress, in, out, lastFileTime, lastSpeed, SList.getbyaddr(a).eff );
                    }
                }
*/
            }
            if(isLog(str,loRun)){
                hour = atoi( str );
                min = atoi( &str[3] )*60+atoi( &str[6] );
                fgets( str, 256, handle );
                if( !isdigit(str[0]) )goto LOOP;
                if( hour == atoi( str ) ){
                    min = atoi( &str[3] )*60+atoi( &str[6] ) - min;
                    if( min > 0 )busy[ atoi( str ) ].run += min;
                }else{
                    busy[ hour ].run += 3600 - min;
                    for( hour++; 1; hour++ ){
                        if( hour == 24 )hour = 0;
                        if( hour == atoi(str) )break;
                        busy[ hour ].run = 3600;
                    }
                    busy[ atoi(str) ].run += atoi( &str[3] )*60+atoi( &str[6] );
                }
                goto LOOP;
            }
            if(isLog(str,loCall)){
                min = atoi( &str[3] )*60+atoi( &str[6] );
                hour = atoi( str );         // for crash-poll
                fgets( str, 256, handle );
                if( !isdigit( str[0] ) )goto LOOP;
                if( hour == atoi(str) ){
                    min = atoi( &str[3] )*60+atoi( &str[6] ) - min;
                    if( min > 0 )busy[ atoi( str ) ].call += min;
                }else{
                    busy[ hour ].call += 3600 - min;
                    for( hour++; 1; hour++ ){
                        if( hour == 24 )hour = 0;
                        if( hour == atoi(str) )break;
                        busy[ hour ].call = 3600;
                    }
                    busy[ atoi(str) ].call += atoi( &str[3] )*60+atoi( &str[6] );
                }
                call = 1;
            }
            if( !strncmp( &str[14], "CONNECT", 7 ) ){
                int succ = 0;
                int filehour, filemin;
                filehour = hour = atoi( str );
                filemin = min = atoi( &str[3] )*60+atoi( &str[6] );
                lastSpeed=atol( &str[21] );
                lastFileTime=0;
//                isHydra=false;
                while( !feof( handle) ){
                    fgets( str, 256, handle );
                    if( !succ ){
                        if(!isLog(str,loInSession))goto LOOP;
                        succ = 1;
                    }
                    if(succ<2 && isLog(str,loAddress)){
                        char buff[64];
                        succ=2;
                        match( MsgCls[loAddress].msg[0], &str[10], '1', buff );
                        atoaddr( lastAddress, buff );
                    }
                    if(isLog(str,loMailer)){
                        match( MsgCls[loMailer].msg[0], &str[10], '1', lastMailer );
                        match( MsgCls[loMailer].msg[0], &str[10], '2', lastMailerV1 );
                        match( MsgCls[loMailer].msg[0], &str[10], '3', lastMailerV2 );
                        filehour = atoi( str );
                        filemin = atoi( &str[3] )*60+atoi( &str[6] );
                    }
                    if(isLog(str,loProtocol)){
//                        char buff[16];
//                        isLog(str,loProtocol,'1',buff);
//                        isHydra=strcmp(buff,"Hydra")==0;
//                        puts( "Protocol is Hydra" );
                        filehour = atoi( str );
                        filemin = atoi( &str[3] )*60+atoi( &str[6] );
                    }
                    if(isLog(str,loSessionEnd))break;
                }
                if( feof(handle) )goto LOOP;

                if( atoi(str) < filehour ){
                    lastFileTime = 3600-filemin;
                    for( filehour++; 1; filehour++ ){
                        if( filehour == 24 )filehour = 0;
                        if( filehour == atoi(str) )break;
                        lastFileTime += 3600;
                    }
                    lastFileTime += atoi( &str[3] )*60+atoi( &str[6] );
                }else{
                    if( atoi(str) == filehour ){
                        lastFileTime = atoi( &str[3] )*60+atoi( &str[6] )-filemin;
                    }else{
                        lastFileTime = 3600-filemin;
                        for( filehour++; filehour < atoi(str); filehour++ ){
                            lastFileTime += 3600;
                        }
                        lastFileTime += atoi( &str[3] )*60+atoi( &str[6] );
                    }
                }

                if( atoi(str) < hour ){
                    if( call )busy[ hour ].out += (3600-min);
                    else busy[ hour ].in += (3600-min);
                    lastOnline = 3600-min;
                    for( hour++; 1; hour++ ){
                        if( hour == 24 )hour = 0;
                        if( hour == atoi(str) )break;
                        if( call )busy[ hour ].out = 3600;
                        else busy[ hour ].in = 3600;
                        lastOnline += 3600;
                    }
                    if( call )busy[ atoi(str) ].out += atoi( &str[3] )*60+atoi( &str[6] );
                    else busy[ atoi(str) ].in += atoi( &str[3] )*60+atoi( &str[6] );
                    lastOnline += atoi( &str[3] )*60+atoi( &str[6] );
                }else{
                    if( atoi(str) == hour ){
                        if( call )busy[ atoi(str) ].out += atoi( &str[3] )*60+atoi( &str[6] )-min;
                        else busy[ atoi(str) ].in += atoi( &str[3] )*60+atoi( &str[6] )-min;
                        lastOnline = atoi( &str[3] )*60+atoi( &str[6] )-min;
                    }else{
                        if( call )busy[ hour ].out += (3600-min);
                        else busy[ hour ].in += (3600-min);
                        lastOnline = 3600-min;
                        for( hour++; hour < atoi(str); hour++ ){
                            if( call )busy[ hour ].out = 3600;
                            else busy[ hour ].in = 3600;
                            lastOnline += 3600;
                        }
                        if( call )busy[ atoi(str) ].out += atoi( &str[3] )*60+atoi( &str[6] );
                        else busy[ atoi(str) ].in += atoi( &str[3] )*60+atoi( &str[6] );
                        lastOnline += atoi( &str[3] )*60+atoi( &str[6] );
                    }
                }
                goto LOOP;
            }
            if(isLog(str,loExit)){
                strncpy( last, str, 8 );
                last[8] = 0;
                xit = 1;
            }
        }
    }
Skip:
    if( xit == 1 && feof( handle ) ){
        xit = 2;
        sprintf( str, "%02d:00:00", tp->tm_hour );
        goto FillXit;
    }
    fclose( handle );
    close( handleBin );
    if( isatty(fileno(stdout)) ){
        cprintf("\r%41s\r", "" );
        flushall();
    }
    switch( sortby ){
        case 'a': sortname="address";
                  cmpf=cmpSesAddress;
                  break;
        case 't': sortname="traffic";
                  cmpf=cmpSesTraffic;
                  break;
        case 'c': sortname="CPS";
                  cmpf=cmpSesCPS;
                  break;
        case 'o': sortname="online time";
                  cmpf=cmpSesOnline;
                  break;
        case 's': sortname="number of sessions";
                  cmpf=cmpSesSessions;
                  break;
        case 'e': sortname="efficiency";
                  cmpf=cmpSesEff;
                  break;
        }
        qsort( SList.list, SList.cnt, sizeof(SessionInfo), cmpf );
        printstat(busy,date2,tp,sortname);
    return 0;
}

static int cmpMailer( const void *p1, const void *p2 )
{
    return strcmp( ((SessionInfo*)p1)->Mailer, ((SessionInfo*)p2)->Mailer );
}

static int cmpMailerUsage( const void *p1, const void *p2 )
{
    if( ((SessionInfo*)p1)->ses > ((SessionInfo*)p2)->ses )return -1;
    if( ((SessionInfo*)p1)->ses < ((SessionInfo*)p2)->ses )return 1;
    return cmpMailer( p1, p2 );
}

void sortMailers(void)
{
    int i;
    qsort( SList.list, SList.cnt, sizeof(SessionInfo), cmpMailer );
    for( i=0; i<SList.cnt; i++ )SList.get(i).ses=1;
    for( i=0; i<SList.cnt; i++ ){
        SessionInfo& si=SList.get(i);
        if( i!=(SList.cnt-1) ){
            if( strcmp( si.Mailer, SList.get(i+1).Mailer )==0 ){
                SList.remove(i+1);
                si.ses++;
                i--;
                continue;
            }
        }
    }
    qsort( SList.list, SList.cnt, sizeof(SessionInfo), cmpMailerUsage );
}