/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#ifndef __SF_GRAPH_H__
#define __SF_GRAPH_H__

#if defined(__DOS__)
#define HOST_OS "DOS"
#elif defined(__OS2__)
#define HOST_OS "2"
#else
#error Undefined host OS
#endif

#include "fidomsg.h"
#include "listdef.hpp"

#define VERSION "3.4"

#pragma ZTC align 1

typedef enum{
    loIncoming,
    loCall,
    loInSession,
    loSessionEnd,
    loRun,
    loExit,
    loSync,
    loTraffic,          // for stations report
    loMailer,           // for stations report
    loAddress,          // for stations report
    loProtocol,         // EMSI-method - end of EMSI
    loCounter           // this should be the last (highest) code
}MessageClasses;

typedef struct{
    char **msg;
    int  cnt;
}MsgClsList;

typedef struct{
    int call;
    int out;
    int in;
    int run;
    int off;
}BUSY;

typedef struct{
    tAddress address;
    long in;
    long out;
    long filetime;
    long online;
    long speed;
    int  ses;
    int  eff;
    char Mailer[32];
    char MailerV1[32];
    char MailerV2[32];
}SessionInfo;

// #define CPS_C 879    //   (DCE*0.91/8)^-1*100%
#define CPS_C 1000   //   (DCE/10)^-1*100%

class SessionList :public listtemp<SessionInfo>{
    public:
    int eff;
    __int64 traffic;
    SessionList(void):listtemp(){
        eff=0;
        traffic=0;
    };
    bool add( tAddress add, long in, long out, long filetime, long online,
              long speed, char Mailer[32], char MailerV1[32], char MailerV2[32] ){
        if(!speed)speed=2400;
        eff=int(((eff*traffic+((__int64)(in+out)*CPS_C/(filetime*speed))*(in+out)))/
                  (traffic+in+out));
        traffic+=in;
        traffic+=out;
        if( inlist(add) ){
            SessionInfo& v=getbyaddr(add);
            v.ses++;
            if(filetime && (v.in+v.out+in+out))
                v.eff=int(
                  ((v.eff*(v.in+v.out)+((__int64)(in+out)*CPS_C/(filetime*speed))*(__int64)(in+out)))/
                  (__int64)(v.in+v.out+in+out));
            v.in+=in;
            v.out+=out;
            v.filetime+=filetime;
            v.online+=online;
            if( v.speed<speed )v.speed=speed;
            strncpy(v.Mailer,Mailer,32);
            v.Mailer[31]=NULL;
            strncpy(v.MailerV1,MailerV1,32);
            v.MailerV1[31]=NULL;
            strncpy(v.MailerV2,MailerV2,32);
            v.MailerV2[31]=NULL;
        }else{
            SessionInfo v;
            v.address=add;
            v.ses=1;
            v.in=in;
            v.out=out;
            v.filetime=filetime;
            v.online=online;
            v.speed=speed;
            strncpy(v.Mailer,Mailer,32);
            v.Mailer[31]=NULL;
            strncpy(v.MailerV1,MailerV1,32);
            v.MailerV1[31]=NULL;
            strncpy(v.MailerV2,MailerV2,32);
            v.MailerV2[31]=NULL;
            if(filetime && (in+out))v.eff=int((__int64)(in+out)*CPS_C/(filetime*speed));
            else v.eff=0;
            return listtemp::add( v );
       }
       return true;
    };
    bool inlist( const tAddress &addr ){
        for( int i=0; i<cnt; i++ ){
            if( addr==list[i].address )return true;
        }
        return false;
    };
    SessionInfo& getbyaddr( const tAddress& add ){
        for( int i=0; i<cnt; i++ )
            if( list[i].address==add )return list[i];
        return list[0];
    }
};


extern MsgClsList  MsgCls[loCounter];
extern SessionList SList;
extern bool showg, showw, showt, showm;

extern void getlang(char *fnm);
extern int isLog(char *line,MessageClasses type);
extern void printstat(BUSY busy[24], char *date2, struct tm *tp, const char *sortname);
extern bool match( char *pattern, const char *str, const char no=0, char *buff=NULL );
extern void sortMailers(void);

#pragma ZTC align

#endif

