/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <malloc.h>
#include <share.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "sf-lng.h"
#include "sf-graph.h"

void getlang(char *fnm)
{
    int handle;
    tLngHdr aLngHeader;
    tLngIdxRec *aLngIndex;
    unsigned char *aLngArray;
    unsigned i;
    static char *EMem = "\nnot anough memory";
    static char *ELng = "\nfile %s is not an lng file or compiler version mismatch";

    for(i=0;i<loCounter;i++){
        MsgCls[i].msg=0;
        MsgCls[i].cnt=0;
    }
    handle=sopen(fnm,O_RDONLY|O_BINARY,SH_DENYWR);
    if(handle<1){
        perror("cannot open lng-file");
        exit(2);
    }
//    lseek(handle,SignLength,SEEK_SET);
    if(read(handle,&aLngHeader,sizeof(tLngHdr))!=sizeof(tLngHdr)){
        printf(ELng,fnm);
        exit(3);
    }
    if(memcmp(aLngHeader.LngSign,DefLngSign,SignLength+1)){
        printf(ELng,fnm);
        exit(3);
    }
    aLngIndex=(tLngIdxRec *)malloc(sizeof(tLngIdxRec)*aLngHeader.TotalMsgs);
    if(!aLngIndex){
        printf(EMem);
        exit(1);
    }
    read(handle,aLngIndex,aLngHeader.TotalMsgs*sizeof(tLngIdxRec));
    aLngArray=(unsigned char*)malloc(aLngHeader.LngArraySiz);
    if(!aLngArray){
        printf(EMem);
        exit(1);
    }
    read(handle,aLngArray,aLngHeader.LngArraySiz);
    close(handle);
    for(i=0;i<aLngHeader.TotalMsgs;i++){
        MessageClasses type;
        char buff[256];
        int j;

        switch(aLngIndex[i].MsgCode){
            case imIncomingDisk:
            case imFaxIncoming:
                                    type=loIncoming;
                                    break;
            case imRun:
            case imOS2OSMode:
            case imOS2DOSMode:
            case imTerminalIn:
            case imRunBBSTout:
            case imDoorWayIn:
            case imRunExternal:
                                    type=loRun;
                                    break;
            case imCalling:
            case imOutGoing:
            case imCrashPoll:
                                    type=loCall;
                                    break;
            case imSynchronizing:
                                    type=loSync;
                                    break;
            case imStation:
                                    type=loInSession;
                                    break;
            case imNormalExit:
            case imUserExit:
            case emFossilNotFound:
            case emCantInitModem:
            case emNodelistError:
            case emCantInitEvents:
            case emCantInitNdlXs:
            case emUndefinedError:
                                    type=loExit;
                                    break;
            case imEMSITout:
            case imReturn:
            case imCrashWith:
            case imFaxReceiveOk:
            case imFaxReceiveFail:
            case imCrashCancel:
            case imSessionOk:
            case imSessionErr:
            case wmKeybAbbort:
            case wmSessKeybAbbort:
            case wmTimeOut:
            case wmNoAnswer:
            case wmNoCarrier:
            case wmNoDial:
            case wmBusy:
            case wmCarrierLost:
            case wmFailEMSI:
            case wmSlowSpeed:
            case wmLowCPS:
            case wmLimitOut:
            case wmCarrierLostProt:
            case wmZModemAbort:
            case wmHBrainDead:
            case wmH5HDLE:
            case wmCrashTout:
            case emNotSession:
            case emRemoteNotComp:
            case wmNoValidAddr:
                                    type=loSessionEnd;
                                    break;
            case imTraffic:
                                    type=loTraffic;
                                    break;
            case imUsing:
                                    type=loMailer;
                                    break;
            case imAddress:
                                    type=loAddress;
                                    break;
            case imMethod:          type=loProtocol;
                                    break;
/*
            case imHRecvComplete:
            case imHSentComplete:
                                    type=loHFileStat;
                                    break;
            case imZRecvComplete:
            case imZRecvComplErr:
            case imZSentComplete:
            case imZSentComplErr:
                                    type=loZFileStat;
                                    break;
*/
            default:                continue;
        }

        strncpy(buff,(char const*)&aLngArray[aLngIndex[i].MsgOfs],(int)aLngArray[aLngIndex[i].MsgOfs-1]);
        buff[(int)aLngArray[aLngIndex[i].MsgOfs-1]]=0;
        j=strlen(buff);
        if(!j)continue;
        MsgCls[type].msg=(char**)realloc(MsgCls[type].msg,sizeof(MsgCls[type].msg)*(MsgCls[type].cnt+1));
        if(!MsgCls[type].msg){
            printf(EMem);
            exit(1);
        }
        MsgCls[type].msg[MsgCls[type].cnt]=(char*)malloc(j+1);
        if(!MsgCls[type].msg[MsgCls[type].cnt]){
            printf(EMem);
            exit(1);
        }
        strcpy(MsgCls[type].msg[MsgCls[type].cnt++],buff);
    }
    free(aLngArray);
    free(aLngIndex);
}

int isLog(char *line,MessageClasses type)
{
    int j;
    j=strlen(line)-1;
    while( j>=0 && (line[j]=='\n' || line[j]=='\r') )j--;
    if( j<0 )return 0;
    line[j+1]=NULL;
    for(int i=0;i<MsgCls[type].cnt;i++){
        if( match( MsgCls[type].msg[i], &line[10] ) ){
            return 1;
        }
    }
    return 0;
}

#define PARM_CHAR '%'

bool match( char *pattern, const char *str, const char no, char *buff )
{
    int i=0,j=0,k=0;

    if(buff)buff[0]=NULL;
    while( pattern[i] && str[j] ){
        if( pattern[i]==PARM_CHAR && isdigit(pattern[i+1]) ){ // parm
            i+=2;
            for( int k=0; pattern[i+k]; k++ ){
                if( pattern[i+k]==PARM_CHAR && isdigit(pattern[i+k+1]) ){ // next parm
                    char *p;
                    char c;
                    c=pattern[i+k];
                    pattern[i+k]=NULL;
                    p=strstr( &str[j], &pattern[i] );
                    pattern[i+k]=c;
                    if( !p )return false;
                    if( buff && pattern[i-1]==no )sprintf( buff, "%.*s", p-&str[j], &str[j] );
                    j+=p-&str[j]+k;
                    i+=k;
                    goto NEXT;
                }
            }
            if( strlen(&str[j])>=k && strcmp( &pattern[i], &str[strlen(str)-k] )==0 ){
                if( buff && pattern[i-1]==no )sprintf( buff, "%.*s", strlen(&str[j])-k, &str[j] );
                return true;
            }else return false;
        }else if( str[j++]!=pattern[i++] )return false;
NEXT: ;
    }
    if( !pattern[i] && str[j] )return false;
    if( !str[j] ){
        while( pattern[i] ){
            if( pattern[i]==PARM_CHAR && isdigit(pattern[i+1]) ){
                i+=2;
            }else return false;
        }
        return true;
    }
    return pattern[i]==str[j];
}
