/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include "sf-graph.h"

#if defined(__DOS__)
static int vm_getscreenheight(void)
{
    return (int)(*((char far *)MK_FP(0x0040, 0x0084)) + 1);
}
#endif // __DOS__
#if defined(__OS2__)
#define INCL_VIO
#include <os2.h>
static int vm_getscreenheight(void)
{
    VIOMODEINFO vi;
    vi.cb = sizeof(VIOMODEINFO);
    VioGetMode(&vi, 0);
    return vi.row;
}
#endif

static void sputlf(void)
{
//    if( !isatty(fileno(stdout)) && isatty(fileno(stdin)) || vm_getscreenwidth()>80 )putchar('\n');
    putchar('\n');
}

static void presskey(void)
{
    if(isatty(fileno(stdout)) && isatty(fileno(stdin))){
        flushall();
        cprintf("Press any key to continue...");
        flushall();
        getch();
        cprintf("\r%40s\r","");
    }
}

static char *filesize7(long size, const int bf=0)
{
    static char buff0[8], buff1[8];
    char *buff=bf?buff1:buff0;
    if( size<10000000l )sprintf( buff, "%7ld", size );
    else{
        size/=1024l;
        if( size<100000l )sprintf( buff, "%5ld K", size );
        else{
            size/=1024l;
            if( size<100000l )sprintf( buff, "%5ld M", size );
            else{
                size/=1024l;
                sprintf( buff, "%5ld G", size );
            }
        }
    }
    return buff;
}

void printstat(BUSY busy[24], char *date2, struct tm *tp, const char *sortname)
{
    int  hour,height;
    long Tcall=0;
    long Tout=0;
    long Tin=0;
    long Trun=0;
    long Toff=0;
    long T24;
    long TTcall;
    long TTout;
    long TTin;
    long TTrun;
    long TToff;

    long Sent=0;
    long Recv=0;
    long online=0;
    long filetime=0;
    long maxspeed=0;
    long ses=0;
    int  mincpsi=-1;
    int  maxcpsi=-1;
    long mincps=LONG_MAX, maxcps=-1;
    int  i;

    if(showg)puts( "Busy");
    for( height = 12; height >= 0; height-- ){
        if(showg){
            if( height == 12 )printf( "100%%" );
            else if( height == 6 )printf( "50%% " );
            else if( height == 0 )printf( "0%%  " );
            else printf( "    " );
        }
        for( hour=0; hour < 24; hour++ ){
            if( busy[hour].in > 3600 )busy[hour].in = 3600;
            if( busy[hour].out > 3600 )busy[hour].out = 3600;
            if( busy[hour].call > 3600 )busy[hour].call = 3600;
            if( busy[hour].run > 3600 )busy[hour].run = 3600;
            if( busy[hour].in < 0 )busy[hour].in = 0;
            if( busy[hour].out < 0 )busy[hour].out = 0;
            if( busy[hour].call < 0 )busy[hour].call = 0;
            if( busy[hour].run < 0 )busy[hour].run = 0;
            if( busy[hour].off > 3600-busy[hour].run-busy[hour].call-busy[hour].out-busy[hour].in )busy[hour].off = 3600-busy[hour].run-busy[hour].call-busy[hour].out-busy[hour].in;
            if( busy[hour].off < 0 )busy[hour].off = 0;
            if( busy[hour].off > 3600 )busy[hour].off = 3600;
            if( height==12 ){
                Tin += busy[hour].in;
                Tout += busy[hour].out;
                Tcall += busy[hour].call;
                Trun += busy[hour].run;
                Toff += busy[hour].off;
            }
            if(!showg)continue;
            if( (busy[hour].call + busy[hour].out + busy[hour].in + busy[hour].run + busy[hour].off) > height*(3600/13) ){ // 3600/13
                if( busy[hour].off > 0 ){
                    if( (busy[hour].off < 3600/13/2) && ((busy[hour].call+busy[hour].out+busy[hour].in+busy[hour].run) > 0) )goto N0;
                    printf( "\xFA\xFA");
                    busy[hour].off -= (3600/13);
                    continue;
                }
                if( busy[hour].run > 0 ){
N0:                 if( (busy[hour].run+busy[hour].off < 3600/13/2) && ((busy[hour].call+busy[hour].out+busy[hour].in) > 0) )goto N1;
                    printf( "::");
                    busy[hour].run -= (3600/13);
                    continue;
                }
                if( busy[hour].in > 0 ){
N1:                 if( (busy[hour].in+busy[hour].run+busy[hour].off < 3600/13/2) && ((busy[hour].call+busy[hour].out) > 0) )goto N2;
                    printf( "" );
                    busy[hour].in -= (3600/13);
                    continue;
                }
                if( busy[hour].out > 0 ){
N2:                 if( (busy[hour].out+busy[hour].in+busy[hour].run+busy[hour].off < 3600/13/2) && (busy[hour].call > 0)  )goto N3;
                    printf( "" );
                    busy[hour].out -= (3600/13);
                    continue;
                }
N3:             printf( "" );
            }else{
                printf( "  " );
            }
        }
        if(!showg)continue;
        if( height == 12 )printf( "  %s statistics", date2 );
        if( height == 11 )printf( "  (24 hours from %d:00)", tp->tm_hour );
        if( height == 10 )printf( "  Station work-load" );
        if( height ==  9 )printf( "  Hour histogram" );
        if( height ==  7 )printf( "  Legend:" );
        if( height ==  6 )printf( "  " );
        if( height ==  5 )printf( "   - Outgoing call" );
        if( height ==  4 )printf( "   - Outgoing session" );
        if( height ==  3 )printf( "   - Incoming session" );
        if( height ==  2 )printf( "  :: - Spawn" );
        if( height ==  1 )printf( "  \xFA\xFA - Offline" );
        putchar( '\n' );
    }
    if(showg){
        printf( "    \n" );
        printf( "     0   2   4   6   8   10  12  14  16  18  20  22  Hour\n\n" );
    }

    if(Tcall%60 > 30)Tcall+= 30;   Tcall /= 60;
    if(Tout%60 > 30) Tout += 30;   Tout /= 60;
    if(Tin%60 > 30)  Tin  += 30;   Tin /= 60;
    if(Trun%60 > 30) Trun += 30;   Trun /= 60;
    if(Toff%60 > 30) Toff += 30;   Toff /= 60;
    TTcall = Tcall;
    TTout = Tout;
    TTin = Tin;
    TTrun = Trun;
    TToff = Toff;

    if(showg && (showw||showt||showm) && isatty(fileno(stdout)) && isatty(fileno(stdin))){
        if(vm_getscreenheight()<36){
            cprintf("Press any key to continue...");
            flushall();
            getch();
            cprintf("\r%40s\r","");
        }
    }

    if(!showw)goto SHOWT;
    printf( "    Ŀ %s\n", date2 );
    printf( "    " );
    for( height = 0; height < 48; height++ ){
        if( (Tcall + Tout + Tin + Trun + Toff) > 0l ){
            if( Tcall > 0 ){
                if( (Tcall < 30l/2) && ((Tout + Tin + Trun + Toff) > 0l) )goto N01;
                putchar( '');
                Tcall -= 30l;
                continue;
            }
            if( Tout > 0 ){
N01:            if( (Tout+Tcall < 30l/2) && ((Tin + Trun + Toff) > 0l) )goto N11;
                putchar( '');
                Tout -= (30l-Tcall);
                Tcall=0;
                continue;
            }
            if( Tin > 0 ){
N11:            if( (Tin+Tout+Tcall < 30l/2) && ((Trun + Toff) > 0l) )goto N21;
                putchar( '' );
                Tin -= (30l-Tout-Tcall);
                Tout=Tcall=0;
                continue;
            }
            if( Trun > 0 ){
N21:            if( (Tout+Tin+Trun+Tcall < 30l/2) && (Toff > 0l) )goto N31;
                putchar( ':' );
                Trun -= (30l-Tin-Tout-Tcall);
                Tin=Tout=Tcall=0;
                continue;
            }
N31:        putchar( '\xFA' );
            Toff -= 30l;
        }else{
            putchar( ' ' );
        }
    }
    printf( " Station work-load\n" );
    printf( "    Ĵ Overall day statistics\n" );
    printf( "                          Total   %%(Work   %%(24  \n" );
    printf( "                          (hour)   time)   hour) \n" );
    printf( "    Ĵ\n" );
    printf( "    Outgoing call       %2ldh %02ld'  %3ld%%    %3ld%%  \n", TTcall/60l, TTcall%60l, (TToff>1430l)?0l:TTcall*100l/(24*60l-TToff), TTcall*100l/(24*60l) );
    printf( "    Outgoing session    %2ldh %02ld'  %3ld%%    %3ld%%  \n", TTout/60l, TTout%60l, (TToff>1430l)?0l:TTout*100l/(24*60l-TToff), TTout*100l/(24*60l) );
    printf( "    Incoming session    %2ldh %02ld'  %3ld%%    %3ld%%  \n", TTin/60l, TTin%60l, (TToff>1430l)?0l:TTin*100l/(24*60l-TToff), TTin*100l/(24*60l) );
    printf( "    Spawn             ::  %2ldh %02ld'  %3ld%%    %3ld%%  \n", TTrun/60l, TTrun%60l, (TToff>1430l)?0l:TTrun*100l/(24*60l-TToff), TTrun*100l/(24*60l) );
    printf( "    Offline           \xFA\xFA  %2ldh %02ld'        %3ld%%  \n", TToff/60l, TToff%60l, TToff*100l/(24*60l) );
    printf( "    Ĵ\n" );
    T24 = TTcall + TTout + TTin + TTrun + TToff;
    printf( "    Busy                  %2ldh %02ld'  %3ld%%    %3ld%%  \n", T24/60l, T24%60l, (TToff>1430l)?100l:(T24-TToff)*100l/(24*60l-TToff), T24*100l/(24*60l) );
    T24 = 24*60l-T24;
    printf( "    Free                  %2ldh %02ld'  %3ld%%    %3ld%%  \n", T24/60l, T24%60l, (TToff>1430l)?0l:100l-((TTcall+TTout+TTin+TTrun)*100l)/(24*60l-TToff), 100l-((TTcall+TTout+TTin+TTrun+TToff)*100l)/(24*60l) );
    printf( "    \n\n" );
    if(showt||showm)presskey();

SHOWT:
    if(!showt)goto SHOWM;
    for( i=0; i<SList.cnt; i++ ){
        SessionInfo& si=SList.get(i);
        const long cps=si.filetime?(si.in+si.out)/si.filetime:0l;
        if( cps ){
            if( mincpsi==-1 || mincps>cps ){
                mincpsi=i;
                mincps=cps;
            }
            if( maxcpsi==-1 || maxcps<cps ){
                maxcpsi=i;
                maxcps=cps;
            }
        }
    }
    int lines;
    printf( "Traffic statistics for %s (sorted by %s)\n", date2, sortname );
    printf( "Ŀ" );
    sputlf();
    printf( "%-14s%-7s%-7s%-3s%-5s%-4s%-3s%-8s%-18s", "Address", "Sent", "Recv", "Ses", "Speed", "~CPS", "Eff", "Online", "Last Mailer" );
    sputlf();
    printf( "Max%%Ĵ" );
    sputlf();
    lines=4;
    for( i=0; i<SList.cnt; i++ ){
        SessionInfo& si=SList.get(i);
        if( isatty(fileno(stdout)) && isatty(fileno(stdin)) && (lines++ == vm_getscreenheight()-1) ){
            presskey();
            lines=1;
        }
        char buff[32*3+1];
        Sent+=si.out;
        Recv+=si.in;
        online+=si.online;
        filetime+=si.filetime;
        maxspeed=(maxspeed>si.speed)?maxspeed:si.speed;
        ses+=si.ses;
        sprintf( buff, "%s %s %s", si.Mailer, si.MailerV1, si.MailerV2 );
        if( strlen(buff)>18 )buff[17]='';
        buff[18]=NULL;
        printf( "%c%-14.14s%c%7s%7s%3d%5ld%4ld%3d%02ld:%02ld:%02ld%-18s",
                (i==maxcpsi)?'+':(i==mincpsi)?'-':'',
                (char*)si.address, (strlen(si.address)>14)?'':'',
                filesize7(si.out,0), filesize7(si.in,1), si.ses, si.speed,
                si.filetime?(si.in+si.out)/si.filetime:0l, si.eff,
                si.online/3600l, (si.online%3600l)/60l, (si.online%3600l)%60l,
                buff );
        sputlf();
    }
    printf( "Ĵ" );
    sputlf();
    printf( "%-7s%-7d%7s%7s%3ld%5ld%4ld%3d%02ld:%02ld:%02ld%18s",
             "Total:", SList.cnt, filesize7(Sent,0), filesize7(Recv,1), ses, maxspeed,
             filetime?(Sent+Recv)/filetime:0l, SList.eff,
             online/3600l, (online%3600l)/60l, (online%3600l)%60l, "" );
    sputlf();
    printf( "" );
    sputlf();
    printf( "Total traffic    : %ld bytes\n\n", Recv+Sent );
    if(showm)presskey();

SHOWM:
    if(!showm)return;
    sortMailers();
    printf( "Mailer usage statistics for %s\n", date2 );
    printf( "Ŀ\n" );
    for( i=0; i<SList.cnt; i++ ){
        const SessionInfo& si=SList.get(i);
        char buff[8];
        printf( "%s", si.Mailer );
        sprintf( buff, "%d", si.ses );
        for( int j=strlen(si.Mailer)+strlen(buff); j<52; j++ )putchar('.');
        printf( "%s\n", buff );
    }
    printf( "\n\n" );
}
