/*                                                                           */
/*                SF-GRAPH 3.4, Santa Fox graphic log analyzer               */
/*           (p) 1995-2000, Stanislav V. Meckhanoshin (2:5030/172.9)         */
/*                      Copyright (c) 1995-2000, Sf-Team                     */
/*                            All rights reserved                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/* This is Public Domain software.                                           */
/* You may use this code for whatever purposes you desire. This software     */
/* is provided AS IS with NO WARRANTY whatsoever.                            */
/* Should this software be used in another application, an acknowledgement   */
/* that this code is used would be appreciated, but is not mandatory.        */
/*                                                                           */
/* See the files license and copying for details.                            */
/*****************************************************************************/

#ifndef __SF_LNG_H__
#define __SF_LNG_H__

#pragma ZTC align 1
#pragma PACK(1);

#define MaxLngIdx   10000      //     { ᨬ쭮 - p  *.lng }
#define MaxLngArray 0xFF00    //     { ᨬ pp ᨢ p }

#define SignLength 27
typedef unsigned char tLngSign[SignLength+1]; //      { ᨣp *.lng 䠩 }

// {  *.lng }
typedef struct{
  tLngSign LngSign;
  unsigned short TotalMsgs;   //         { 饥 - p  *.lng }
  unsigned short LngArraySiz; //         { pp ᨢ p }
}tLngHdr;

// {   }
typedef struct{
  unsigned short MsgCode;     //         {  p }
  unsigned short MsgOfs;      //         { ᬥ饭  ᨢ p }
}tLngIdxRec;

#define DefLngSign "\x1B(ad) Language file v0.0.1/a"

#define imLoading                1001
#define imCompiling              1002
#define imKilled                 1003
#define imGRSdetected            1004
#define imGRSkilled              1005
#define imRepackSem              1006
#define imRSkilled               1007
#define imRestoring              1008
#define imLook4StartupEvt        1009
#define imSUset                  1010
#define imClearingMem            1011
#define imReInitSystem           1012
#define imWaitMsg                1013
#define imMsgRouted              1014
#define imRepackFor              1015
#define imPSmonitoring           1016
#define imScanCreate             1017
#define imCreate                 1018
#define imLook4hotEvt            1019
#define imNoHotEvt               1020
#define imNewMsgs                1021
#define imEvent                  1022
#define imExiting                1023
#define imCheckHIP               1024
#define imSearchActiveQue        1025
#define imNoActiveQue            1026
#define imFRQlistFor             1027
#define imRemoteIsLame           1028
#define imFRQlistStart           1029
#define imFRQlistEnd             1030
#define imFRQsrvrPwd             1031
#define imFwdIntoNetmail         1032
#define imFwdIntoMailBox         1033
#define imInitProcMan            1034
#define imSemDetected            1035
#define imSemKilled              1036
#define imRemoteStatus           1037
#define imEMSIflags              1038
#define imZMHsession             1039
#define imGenMsg                 1040
#define imGenBinkPoll            1041
#define imGenBinkFReq            1042
#define imGenBinkAtch            1043
#define imGenBoxAtch             1044
#define imScanBO                 1045
#define imWritingNewLog          1046
#define imCutLogStart            1047
#define imCutLog                 1048
#define imCutLogEnd              1049
#define imProcSet                1050
#define imProcDrop               1051
#define imProcPoll               1052
#define imMTchanged              1053
#define imUnpacking              1054
#define imPktFromTo              1055
#define imUnpackMsg              1056
#define imEmpty                  1057
#define imKilledFwdFRQ           1058
#define imTransitMsg             1059
#define imIncomingDisk           1060
#define imIncomingScreen         1061
#define imRingIgnore             1062
#define imTryEMSI                1063
#define imEstablishEMSI          1064
#define imAttemptEMSI            1065
#define imSendingEMSI            1066
#define imReceivingEMSI          1067
#define imAnalysing              1068
#define imTerminalIn             1069
#define imDoorWayIn              1070
#define imDoorWayOut             1071
#define imRunExternal            1072
#define imHardRing               1073
#define imSoftRing               1074
#define imStatistic              1075
#define imStatSendBytes          1076
#define imStatRecvBytes          1077
#define imStatSessions           1078
#define imManualSet              1079
#define imCalling                1080
#define imOutGoing               1081
#define imHuman                  1082
#define imHumanReject            1083
#define imStation                1084
#define imAddress                1085
#define imAKAs                   1086
#define imSysop                  1087
#define imLocation               1088
#define imPhone                  1089
#define imFlags                  1090
#define imUsing                  1091
#define imRemoteDate             1092
#define imTraffIn                1093
#define imProtected              1094
#define imUnProtected            1095
#define imSynchronizing          1096
#define imRunBBSTout             1097
#define imEMSITout               1098
#define imSessBegin              1099
#define imSessBeginLimit         1100
#define imInitModem              1101
#define imInitModemLock          1102
#define imRefreshModem           1103
#define imWriteStat              1104
#define imStatDone               1105
#define imCreated                1106
#define imFlagExist              1107
#define imFlagCheck              1108
#define imFlagAbsent             1109
#define imWaitFlag               1110
#define imRunBlocked             1111
#define imGoOffHook              1112
#define imGoOnHook               1113
#define imRun                    1114
#define imReturn                 1115
#define imOS2OSMode              1116
#define imOS2DOSMode             1117
#define imCrashRecovery          1118
#define imCrashWith              1119
#define imRunFromExternal        1120
#define imZSCompleteMsg          1121
#define imZRCompleteMsg          1122
#define imZRecvComplete          1123
#define imZRecvComplErr          1124
#define imZSendComplete          1125
#define imZSendComplErr          1126
#define imZRequestSkip           1127
#define imZSkipping              1128
#define imZSkipKeyboard          1129
#define imHSend                  1130
#define imHRecv                  1131
#define imZSend                  1132
#define imZRecv                  1133
#define imHRecvComplete          1134
#define imHSentComplete          1135
#define imRemoteHydCan           1136
#define imRemoteHydWant          1137
#define imHSkipNext              1138
#define imHSkip                  1139
#define imHResending             1140
#define imHResuming              1141
#define imZResuming              1142
#define imReplace                1143
#define imSynchronize            1144
#define imBatchCompl             1145
#define imFaxIncoming            1146
#define imFaxRemoteId            1147
#define imFaxSpeed               1148
#define imFaxResolution          1149
#define imFaxReceive             1150
#define imFaxReceiveOk           1151
#define imFaxReceiveFail         1152
#define imCrashPoll              1153
#define imCrashCancel            1154
#define imMethod                 1155
#define imNonStandartSup         1156
#define imSessionOk              1157
#define imSessionErr             1158
#define imTraffic                1159
#define imSessionCPS             1160
#define imCloseSession           1161
#define imNormalExit             1162
#define imUserExit               1163
#define imFossInfo               1164
#define imFossRevision           1165
#define imMaxFunctions           1166
#define imBuffersInfo            1167
#define imDOSInfo                1168
#define imChangeRelease          1169
#define imChangeTimeQ            1170
#define imBroadCastFile          1171
#define wmIdxTimeWarn            2001
#define wmRouteTimeWarn          2002
#define wmEventTimeWarn          2003
#define wmBinCfgAbsent           2004
#define wmCfgTimeWarn            2005
#define wmSubstTimeWarn          2006
#define wmHIPoverflow            2007
#define wmQueOverflow            2008
#define wmPollSkipped            2009
#define wmTooLarge               2010
#define wmFRQnotForUs            2011
#define wmFRQNotAcceptNow        2012
#define wmFRQnotAllowed          2013
#define wmFRQtooSlow             2014
#define wmFRQfailed              2015
#define wmTooManyMsgs            2016
#define wmNetmailIsEmpty         2017
#define wmPwdNotUsed             2018
#define wmPwdTimeWarn            2019
#define wmAddrOccuped            2020
#define wmOtherMainAddr          2021
#define wmBusyFor                2022
#define wmBinkPollSkipped        2023
#define wmAttachDroped           2024
#define wmArcMailInPkt           2025
#define wmZSendFailed            2026
#define wmZRecvFailed            2027
#define wmKeybAbbort             2028
#define wmSessKeybAbbort         2029
#define wmTimeOut                2030
#define wmNoAnswer               2031
#define wmNoCarrier              2032
#define wmNoDial                 2033
#define wmBusy                   2034
#define wmCarrierLost            2035
#define wmFailEMSI               2036
#define wmBadCRCEMSI             2037
#define wmSlowSpeed              2038
#define wmInvalidSN              2039
#define wmBadPwd                 2040
#define wmBadPwdRecv             2041
#define wmBadPwdExpect           2042
#define wmNoValidAddr            2043
#define wmCantSend               2044
#define wmLowCPS                 2045
#define wmLimitIn                2046
#define wmLimitOut               2047
#define wmRecvFailed             2048
#define wmSendFailed             2049
#define wmHTimeOut               2050
#define wmHManyError             2051
#define wmCarrierLostProt        2052
#define wmZModemAbort            2053
#define wmHBrainDead             2054
#define wmH5HDLE                 2055
#define wmHBadPos                2056
#define wmErrFreeSpace           2057
#define wmSkippingNull           2058
#define wmZCantSyncRecv          2059
#define wmZCantSyncSend          2060
#define wmZLongPacket            2061
#define wmZBadCRC                2062
#define wmZBadPos                2063
#define wmZTimeOut               2064
#define wmZGlobalTout            2065
#define wmZMaxWrongPack          2066
#define wmZMaxBadPos             2067
#define wmCantFindNode           2068
#define wmUnpublishNode          2069
#define wmCrashTout              2070
#define emDriveNotReady          3001
#define emNoFilesFound           3002
#define emCantOpen               3003
#define emCantCreate             3004
#define emCantSeek               3005
#define emCantFind               3006
#define emReadError              3007
#define emWriteError             3008
#define emCantKill               3009
#define emNdlTimeError           3010
#define emBadCmd                 3011
#define emUndefinedTPer          3012
#define emBadTargetAddr          3013
#define emInvalidTPer            3014
#define emCantCloseEM            3015
#define emFRQwoSubj              3016
#define emATCHwoSubj             3017
#define emCantAccessMail         3018
#define emCantAccessIdx          3019
#define emRepackError            3020
#define emIoError                3021
#define emCLM                    3022
#define emBadPath                3023
#define emUndefinedPM            3024
#define emProcStructCorr         3025
#define emLostQue                3026
#define emNoMemForCache          3027
#define emCFGinvalidSect         3028
#define emCFGinvalidArg          3029
#define emCFGunXpected           3030
#define emCFGcantSet             3031
#define emCFG2manyNested         3032
#define emMTBadTrackDat          3033
#define emSMdata2large           3034
#define emInvalidPkt             3035
#define emNotSession             3036
#define emNotVoice               3037
#define emNotFax                 3038
#define emNotShell               3039
#define emNotEditor              3040
#define emInvalidAddr            3041
#define emInitStr                3042
#define emNotInit                3043
#define emNotRefresh             3044
#define emWriteStat              3045
#define emFossilOut              3046
#define emSemNotFound            3047
#define emHCantFind              3048
#define emHCantOpen              3049
#define emHIOError               3050
#define emFossilNotFound         3051
#define emCantInitModem          3052
#define emNodelistError          3053
#define emCantInitEvents         3054
#define emCantInitNdlXs          3055
#define emUndefinedError         3056
#define emRemoteNotComp          3057

#pragma ZTC align
#pragma PACK();

#endif


