// UDDiag.cpp : Implementation of CUDDiag
#include "stdafx.h"
#include "Udw.h"
#include "UDDiag.h"

extern "C"{
BOOL isOleCall=FALSE;
extern char *edit_buff;
extern int MakeStat(void* hIn);
extern char* prefix;
}
#define INIT_EDIT_BUFF_SIZE 4096

/////////////////////////////////////////////////////////////////////////////
// CUDDiag

CUDDiag::CUDDiag()
{
    prefix=(char*)malloc(1);
    if( prefix ) prefix[0]=0;
}

CUDDiag::~CUDDiag()
{
    if( prefix ) free(prefix);
}

STDMETHODIMP CUDDiag::get_UDDiag(BSTR bstrResponse, BSTR *pVal)
{
    int len=wcslen(bstrResponse)+1;
    char* pResp=(char*)malloc(len);
    int ret;

    *pVal=0;
    if( !pResp )return E_OUTOFMEMORY;
    WideCharToMultiByte(CP_ACP,0,bstrResponse,-1,pResp,len,0,0);
    pResp[len-1]=0;
    isOleCall=TRUE;
    edit_buff=(char*)HeapAlloc(GetProcessHeap(),HEAP_GENERATE_EXCEPTIONS|HEAP_ZERO_MEMORY,INIT_EDIT_BUFF_SIZE);
    if( !edit_buff ){
        free(pResp);
        return E_OUTOFMEMORY;
    }
    ret=MakeStat(pResp);
    isOleCall=FALSE;
    free(pResp);
    len=strlen(edit_buff)+1;
    *pVal=SysAllocStringLen(NULL,len);
    if( !*pVal ){
		HeapFree(GetProcessHeap(),0,edit_buff);
        return E_OUTOFMEMORY;
    }
    MultiByteToWideChar(CP_ACP,0,edit_buff,-1,*pVal,len);
    (*pVal)[len-1]=0;
    HeapFree(GetProcessHeap(),0,edit_buff);
    return ret?S_FALSE:S_OK;
}

STDMETHODIMP CUDDiag::get_Prefix(BSTR *pVal)
{
    int len=strlen(prefix)+1;
    *pVal=SysAllocStringLen(NULL,len);
    if( !*pVal )return E_OUTOFMEMORY;
    MultiByteToWideChar(CP_ACP,0,prefix,-1,*pVal,len);
    return S_OK;
}

STDMETHODIMP CUDDiag::put_Prefix(BSTR newVal)
{
    int len=wcslen(newVal)+1;
    if( prefix )free(prefix);
    prefix=(char*)malloc(len);
    if( !prefix )return E_OUTOFMEMORY;
    WideCharToMultiByte(CP_ACP,0,newVal,-1,prefix,len,0,0);
    prefix[len-1]=0;
    return S_OK;
}
