// udw.cpp : Implementation of WinMain


// Note: Proxy/Stub Information
//      To build a separate proxy/stub DLL, 
//      run nmake -f udwps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "udw.h"

#include "udw_i.c"
#include "UDDiag.h"


const DWORD dwTimeOut = 5000; // time for EXE to be idle before shutting down
const DWORD dwPause = 1000; // time to wait for threads to finish up

// Passed to CreateThread to monitor the shutdown event
static DWORD WINAPI MonitorProc(void* pv)
{
    CExeModule* p = (CExeModule*)pv;
    p->MonitorShutdown();
    return 0;
}

LONG CExeModule::Unlock()
{
    LONG l = CComModule::Unlock();
    if (l == 0)
    {
        bActivity = true;
        SetEvent(hEventShutdown); // tell monitor that we transitioned to zero
    }
    return l;
}

//Monitors the shutdown event
void CExeModule::MonitorShutdown()
{
    while (1)
    {
        WaitForSingleObject(hEventShutdown, INFINITE);
        DWORD dwWait=0;
        do
        {
            bActivity = false;
            dwWait = WaitForSingleObject(hEventShutdown, dwTimeOut);
        } while (dwWait == WAIT_OBJECT_0);
        // timed out
        if (!bActivity && m_nLockCnt == 0) // if no activity let's really bail
        {
#if _WIN32_WINNT >= 0x0400 & defined(_ATL_FREE_THREADED)
            CoSuspendClassObjects();
            if (!bActivity && m_nLockCnt == 0)
#endif
                break;
        }
    }
    CloseHandle(hEventShutdown);
    PostThreadMessage(dwThreadID, WM_QUIT, 0, 0);
}

bool CExeModule::StartMonitor()
{
    hEventShutdown = CreateEvent(NULL, false, false, NULL);
    if (hEventShutdown == NULL)
        return false;
    DWORD dwThreadID;
    HANDLE h = CreateThread(NULL, 0, MonitorProc, this, 0, &dwThreadID);
    return (h != NULL);
}

CExeModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_UDDiag, CUDDiag)
END_OBJECT_MAP()


LPCTSTR FindOneOf(LPCTSTR p1, LPCTSTR p2)
{
    while (p1 != NULL && *p1 != NULL)
    {
        LPCTSTR p = p2;
        while (p != NULL && *p != NULL)
        {
            if (*p1 == *p)
                return CharNext(p1);
            p = CharNext(p);
        }
        p1 = CharNext(p1);
    }
    return NULL;
}

static HRESULT ComInitModule(HINSTANCE hInstance)
{
#if _WIN32_WINNT >= 0x0400 & defined(_ATL_FREE_THREADED)
    HRESULT hRes = CoInitializeEx(NULL, COINIT_MULTITHREADED);
#else
    HRESULT hRes = CoInitialize(NULL);
#endif
    _ASSERTE(SUCCEEDED(hRes));
    _Module.Init(ObjectMap, hInstance, &LIBID_UDWLib);
    _Module.dwThreadID = GetCurrentThreadId();
    return hRes;
}

extern "C" int WINAPI WinMainAlone(HINSTANCE,HINSTANCE,LPSTR,int);

/////////////////////////////////////////////////////////////////////////////
//
extern "C" int WINAPI _tWinMain(HINSTANCE hInstance, 
    HINSTANCE hPrevInstance, LPTSTR lpCmdLineOrg, int nShowCmd)
{
    const TCHAR szTokens[] = _T("-/");
    HRESULT hRes;
    LPTSTR lpCmdLine;

    lpCmdLine = GetCommandLine(); //this line necessary for _ATL_MIN_CRT

    int nRet = 0;
    BOOL bRun = TRUE;
    BOOL bEmbedding=FALSE;
    LPCTSTR lpszToken = FindOneOf(lpCmdLine, szTokens);
    while (lpszToken != NULL)
    {
        if (lstrcmpi(lpszToken, _T("UnregServer"))==0)
        {
            hRes=ComInitModule(hInstance);
            _Module.UpdateRegistryFromResource(IDR_Udw, FALSE);
            nRet = _Module.UnregisterServer(TRUE);
            bRun = FALSE;
            MessageBox(HWND_DESKTOP,_T("Server Unregistered"),"Rockwell Diagnostics",MB_OK);
            break;
        }
        if (lstrcmpi(lpszToken, _T("RegServer"))==0)
        {
            hRes=ComInitModule(hInstance);
            _Module.UpdateRegistryFromResource(IDR_Udw, TRUE);
            nRet = _Module.RegisterServer(TRUE);
            bRun = FALSE;
            MessageBox(HWND_DESKTOP,_T("Server Registration Done"),"Rockwell Diagnostics",MB_OK);
            break;
        }
        if (lstrcmpi(lpszToken, _T("Embedding"))==0)
        {
            bEmbedding=TRUE;
        }
        lpszToken = FindOneOf(lpszToken, szTokens);
    }

    if (bRun)
    {
        if( !bEmbedding )return WinMainAlone(hInstance,hPrevInstance,lpCmdLineOrg,nShowCmd);
        hRes=ComInitModule(hInstance);
        _Module.StartMonitor();
#if _WIN32_WINNT >= 0x0400 & defined(_ATL_FREE_THREADED)
        hRes = _Module.RegisterClassObjects(CLSCTX_LOCAL_SERVER, 
            REGCLS_MULTIPLEUSE | REGCLS_SUSPENDED);
        _ASSERTE(SUCCEEDED(hRes));
        hRes = CoResumeClassObjects();
#else
        hRes = _Module.RegisterClassObjects(CLSCTX_LOCAL_SERVER, 
            REGCLS_MULTIPLEUSE);
#endif
        _ASSERTE(SUCCEEDED(hRes));

        MSG msg;
        while (GetMessage(&msg, 0, 0, 0))
            DispatchMessage(&msg);

        _Module.RevokeClassObjects();
        Sleep(dwPause); //wait for any threads to finish
    }

    _Module.Term();
    CoUninitialize();
    return nRet;
}
